//#################################################################
//
//	Sequence.cpp : Deal with all behavior of sequence
//
//#################################################################
#include "stdafx.h"
#include "Define.h"
#include "SpeedDome.h"
#include "ControlDlg.h"
#include "presetdlg.h"
#include "sequencedlg.h"
#include "misc.h"
#include "Comm.h"
#include "winbase.h"
#include "Sequence.h"
#include "GlobalVar.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//#################################################################
// S_Sequence( )
//
// Cam sequence motion command function
//#################################################################
void CSequence::S_Sequence(UINT SQNum)
{
DWORD			NumberOfBytesWritten;
DWORD			NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			Packet[6]={'\x0','\x0','\x11','\x01','\x0','\x0'};

Flag_Polling=0;
Sleep(100);

Packet[0]=(char)G_DomeID;
Packet[4]=(char)SQNum-1;
Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];

CComm::RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);

Flag_Polling=1;
}


//###############################################################
//
// UINT S_SequenceIDToNum(UINT ID)
//
// ID : Sequence point ID
//###############################################################
UINT CSequence::S_SequenceIDToNum(UINT ID,LPSTR *IDBName)
{
UINT	Num;
UINT	IDBBuffer[9]=
		{	IDB_SQ_CRUISE_DOMED,IDB_SQ_CRUISE_NUM1D,IDB_SQ_CRUISE_NUM2D,
			IDB_SQ_CRUISE_NUM3D,IDB_SQ_CRUISE_NUM4D,IDB_SQ_CRUISE_NUM5D,
			IDB_SQ_CRUISE_NUM6D,IDB_SQ_CRUISE_NUM7D,IDB_SQ_CRUISE_MORED,};

switch(ID)
	{
	case IDC_SQ_DOME: Num=0;	break;
	case IDC_SQ_NUM1: Num=1;	break;
	case IDC_SQ_NUM2: Num=2;	break;
	case IDC_SQ_NUM3: Num=3;	break;
	case IDC_SQ_NUM4: Num=4;	break;
	case IDC_SQ_NUM5: Num=5;	break;
	case IDC_SQ_NUM6: Num=6;	break;
	case IDC_SQ_NUM7: Num=7;	break;
	}

*IDBName=MAKEINTRESOURCE( IDBBuffer[Num] );

return (Num);
}


//###############################################################
//
// UINT S_SequenceIDBuffer()
//
// ID : Sequence point ID
//###############################################################
void CSequence::S_SequenceIDBuffer(UINT *IDBuffer,int column)
{
//--1
*(IDBuffer)=IDC_SQ01_TIME;					*(IDBuffer+1)=IDC_SQ01_PAN_SPEED;			
*(IDBuffer+2)=IDC_SQ01_TILT_SPEED;			*(IDBuffer+3)=IDC_SQ01;							
//--2
*(IDBuffer+1*column)=IDC_SQ02_TIME;			*(IDBuffer+1*column+1)=IDC_SQ02_PAN_SPEED;	
*(IDBuffer+1*column+2)=IDC_SQ02_TILT_SPEED;	*(IDBuffer+1*column+3)=IDC_SQ02;				
//--3
*(IDBuffer+2*column)=IDC_SQ03_TIME;			*(IDBuffer+2*column+1)=IDC_SQ03_PAN_SPEED;	
*(IDBuffer+2*column+2)=IDC_SQ03_TILT_SPEED;	*(IDBuffer+2*column+3)=IDC_SQ03;				
//--4
*(IDBuffer+3*column)=IDC_SQ04_TIME;			*(IDBuffer+3*column+1)=IDC_SQ04_PAN_SPEED;	
*(IDBuffer+3*column+2)=IDC_SQ04_TILT_SPEED;	*(IDBuffer+3*column+3)=IDC_SQ04;				
//--5
*(IDBuffer+4*column)=IDC_SQ05_TIME;			*(IDBuffer+4*column+1)=IDC_SQ05_PAN_SPEED;
*(IDBuffer+4*column+2)=IDC_SQ05_TILT_SPEED;	*(IDBuffer+4*column+3)=IDC_SQ05;				
//--6
*(IDBuffer+5*column)=IDC_SQ06_TIME;			*(IDBuffer+5*column+1)=IDC_SQ06_PAN_SPEED;	
*(IDBuffer+5*column+2)=IDC_SQ06_TILT_SPEED;	*(IDBuffer+5*column+3)=IDC_SQ06;				
//--7
*(IDBuffer+6*column)=IDC_SQ07_TIME;			*(IDBuffer+6*column+1)=IDC_SQ07_PAN_SPEED;	
*(IDBuffer+6*column+2)=IDC_SQ07_TILT_SPEED;	*(IDBuffer+6*column+3)=IDC_SQ07;
//--8
*(IDBuffer+7*column)=IDC_SQ08_TIME;			*(IDBuffer+7*column+1)=IDC_SQ08_PAN_SPEED;	
*(IDBuffer+7*column+2)=IDC_SQ08_TILT_SPEED;	*(IDBuffer+7*column+3)=IDC_SQ08;				
//--9
*(IDBuffer+8*column)=IDC_SQ09_TIME;			*(IDBuffer+8*column+1)=IDC_SQ09_PAN_SPEED;	
*(IDBuffer+8*column+2)=IDC_SQ09_TILT_SPEED;	*(IDBuffer+8*column+3)=IDC_SQ09;				
//--10
*(IDBuffer+9*column)=IDC_SQ10_TIME;			*(IDBuffer+9*column+1)=IDC_SQ10_PAN_SPEED;	
*(IDBuffer+9*column+2)=IDC_SQ10_TILT_SPEED;	*(IDBuffer+9*column+3)=IDC_SQ10;				
//--11
*(IDBuffer+10*column)=IDC_SQ11_TIME;			*(IDBuffer+10*column+1)=IDC_SQ11_PAN_SPEED;	
*(IDBuffer+10*column+2)=IDC_SQ11_TILT_SPEED;	*(IDBuffer+10*column+3)=IDC_SQ11;				
//--12
*(IDBuffer+11*column)=IDC_SQ12_TIME;			*(IDBuffer+11*column+1)=IDC_SQ12_PAN_SPEED;	
*(IDBuffer+11*column+2)=IDC_SQ12_TILT_SPEED;	*(IDBuffer+11*column+3)=IDC_SQ12;				
//--13
*(IDBuffer+12*column)=IDC_SQ13_TIME;			*(IDBuffer+12*column+1)=IDC_SQ13_PAN_SPEED;	
*(IDBuffer+12*column+2)=IDC_SQ13_TILT_SPEED;	*(IDBuffer+12*column+3)=IDC_SQ13;				
//--14
*(IDBuffer+13*column)=IDC_SQ14_TIME;			*(IDBuffer+13*column+1)=IDC_SQ14_PAN_SPEED;	
*(IDBuffer+13*column+2)=IDC_SQ14_TILT_SPEED;	*(IDBuffer+13*column+3)=IDC_SQ14;				
//--15
*(IDBuffer+14*column)=IDC_SQ15_TIME;			*(IDBuffer+14*column+1)=IDC_SQ15_PAN_SPEED;	
*(IDBuffer+14*column+2)=IDC_SQ15_TILT_SPEED;	*(IDBuffer+14*column+3)=IDC_SQ15;				
//--16
*(IDBuffer+15*column)=IDC_SQ16_TIME;			*(IDBuffer+15*column+1)=IDC_SQ16_PAN_SPEED;	
*(IDBuffer+15*column+2)=IDC_SQ16_TILT_SPEED;	*(IDBuffer+15*column+3)=IDC_SQ16;				
}

//###############################################################
//
// UINT S_GetSequenceParaFile(Num,Para)
//
// UINT Num  : Sequence number
// UINT Para : Sequence para
//###############################################################

void CSequence::S_GetSequenceParaFile(UINT Num,char *Para)
{
HANDLE			hSQ,hMap;
unsigned char 	*Fptr;
UINT			Temp;
UINT			Offset=0;

hSQ=CreateFile("Sequence.rec",GENERIC_READ,FILE_SHARE_READ,NULL,
				OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
hMap=CreateFileMapping( hSQ,NULL,PAGE_READONLY,0,0,NULL);
Fptr=(unsigned char *)MapViewOfFile(hMap,FILE_MAP_READ,0,0,0);

Offset=(Num-1)*AVL_NUM_SEQUENCE*EE_SIZE_SEQUENCE;

for( int i=0;i<=(REAL_NUM_SEQUENCE-1);i++ )
	{//------------------
	for( int j=0;j<=(EE_SIZE_SEQUENCE-1);j++ )
		{
		Temp=*(Fptr+Offset+i*EE_SIZE_SEQUENCE+j);
		if(Temp==0xff)
			*(Para+i*EE_SIZE_SEQUENCE+j)=0;
		else
			{
			if( j==3 )		//-- Just modify Sequence point 
				*(Para+i*EE_SIZE_SEQUENCE+j)=Temp+1;
			else
				*(Para+i*EE_SIZE_SEQUENCE+j)=Temp;
			}
		}
	}//------------------


UnmapViewOfFile(Fptr); 
CloseHandle(hMap);
CloseHandle(hSQ);

}

//###############################################################
//
// UINT S_GetSequenceParaEE(Para)
//
// UINT Para : Sequence para
//###############################################################

void CSequence::S_GetSequenceParaEE(UINT Num,char *Para)
{
char	Y_Para[REAL_NUM_SEQUENCE*EE_SIZE_SEQUENCE];
char	EEAddr[3];
WORD	Y_Addr;
UINT	Offset=0;

Flag_Polling=0;
Sleep(100);

Offset=(Num-1)*AVL_NUM_SEQUENCE*EE_SIZE_SEQUENCE;
Y_Addr=EE_BASE_SEQUENCE+Offset;

EEAddr[0]=LOBYTE(Y_Addr);
EEAddr[1]=HIBYTE(Y_Addr);

CComm::S_COM_AccessEEData(1,EEAddr,
						  REAL_NUM_SEQUENCE*EE_SIZE_SEQUENCE,Y_Para);  //-- Get SQ parameter

for( int i=0; i<=(REAL_NUM_SEQUENCE-1) ; i++ )
	{
	for(int j=0;j<=(EE_SIZE_SEQUENCE-1);j++ )
		{
		if( j==3 )		//-- Just modify Sequence point 
			{
			if ( (Y_Para[i*EE_SIZE_SEQUENCE+j]== '\xff')||
				 (Y_Para[i*EE_SIZE_SEQUENCE+j]== '\xfe')	)
				*(Para+i*EE_SIZE_SEQUENCE+j)='\x0';	//Y_Para[i]=0;
			else
				*(Para+i*EE_SIZE_SEQUENCE+j)=(unsigned int)Y_Para[i*EE_SIZE_SEQUENCE+j]+1;
			}
		else
			{
			if ( Y_Para[i*EE_SIZE_SEQUENCE+j]== '\xff' )
				*(Para+i*EE_SIZE_SEQUENCE+j)='\x0';	//Y_Para[i]=0;
			else
				*(Para+i*EE_SIZE_SEQUENCE+j)=Y_Para[i*EE_SIZE_SEQUENCE+j];
			}
		}
	}

Flag_Polling=1;

}



//###############################################################
//
// UINT S_WriteSequenceParaFile(Num,Para)
//
// UINT Num  : Sequence number
// UINT Para : Sequence para
//###############################################################

void CSequence::S_WriteSequenceParaFile(UINT Num,UINT *Para)
{
HANDLE			hSQ,hMap;
unsigned char 	*Fptr;
UINT			Offset;

hSQ=CreateFile("Sequence.rec",GENERIC_READ|GENERIC_WRITE,FILE_SHARE_WRITE,NULL,
				OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
hMap=CreateFileMapping( hSQ,NULL,PAGE_READWRITE,0,0,NULL);
Fptr=(unsigned char *)MapViewOfFile(hMap,FILE_MAP_WRITE,0,0,0);

Offset=(Num-1)*AVL_NUM_SEQUENCE*EE_SIZE_SEQUENCE;

for(int i=0;i<=(REAL_NUM_SEQUENCE-1) ;i++)
	{
	for( int j=0;j<=(EE_SIZE_SEQUENCE-1);j++ )
		{
		*(Fptr+Offset+i*EE_SIZE_SEQUENCE+j)=
					Para[i*EE_SIZE_SEQUENCE+j];
		}
	}

FlushViewOfFile(Fptr,0);
UnmapViewOfFile(Fptr); 
CloseHandle(hMap);
CloseHandle(hSQ);

}

//###############################################################
//
// UINT S_WriteSequenceParaEE(Para)
//
// UINT Para : Sequence para
//###############################################################

void CSequence::S_WriteSequenceParaEE(UINT Num,UINT *Para)
{
char	EEAddr[3];
char	Temp[REAL_NUM_SEQUENCE*EE_SIZE_SEQUENCE];
WORD	Y_Addr;

Flag_Polling=0;
Sleep(100);

Y_Addr=EE_BASE_SEQUENCE+
	   EE_SIZE_SEQUENCE*AVL_NUM_SEQUENCE*(Num-1);

for ( int i=0;i<=(REAL_NUM_SEQUENCE*EE_SIZE_SEQUENCE-1);i++ )
	Temp[i]=Para[i];

EEAddr[0]=LOBYTE(Y_Addr);
EEAddr[1]=HIBYTE(Y_Addr);

CComm::S_COM_AccessEEData(0,EEAddr,
						  REAL_NUM_SEQUENCE*EE_SIZE_SEQUENCE,Temp);

Flag_Polling=1;
}

//###############################################################
//
// S_GetSequenceParaDlg()
//
//###############################################################
void CSequence::S_GetSequenceParaDlg(UINT *Para,int col)
{
UINT	Temp;

*(Para)=G_SequenceDlg->m_SQ01_Time;					*(Para+1)=G_SequenceDlg->m_SQ01_PanSpeed;			
*(Para+2)=G_SequenceDlg->m_SQ01_TiltSpeed;			*(Para+3)=G_SequenceDlg->m_SQ01;

*(Para+1*col)=G_SequenceDlg->m_SQ02_Time;			*(Para+1*col+1)=G_SequenceDlg->m_SQ02_PanSpeed;		
*(Para+1*col+2)=G_SequenceDlg->m_SQ02_TiltSpeed;	*(Para+1*col+3)=G_SequenceDlg->m_SQ02;				

*(Para+2*col)=G_SequenceDlg->m_SQ03_Time;			*(Para+2*col+1)=G_SequenceDlg->m_SQ03_PanSpeed;		
*(Para+2*col+2)=G_SequenceDlg->m_SQ03_TiltSpeed;	*(Para+2*col+3)=G_SequenceDlg->m_SQ03;

*(Para+3*col)=G_SequenceDlg->m_SQ04_Time;			*(Para+3*col+1)=G_SequenceDlg->m_SQ04_PanSpeed;		
*(Para+3*col+2)=G_SequenceDlg->m_SQ04_TiltSpeed;	*(Para+3*col+3)=G_SequenceDlg->m_SQ04;

*(Para+4*col)=G_SequenceDlg->m_SQ05_Time;			*(Para+4*col+1)=G_SequenceDlg->m_SQ05_PanSpeed;		
*(Para+4*col+2)=G_SequenceDlg->m_SQ05_TiltSpeed;	*(Para+4*col+3)=G_SequenceDlg->m_SQ05;

*(Para+5*col)=G_SequenceDlg->m_SQ06_Time;			*(Para+5*col+1)=G_SequenceDlg->m_SQ06_PanSpeed;		
*(Para+5*col+2)=G_SequenceDlg->m_SQ06_TiltSpeed;	*(Para+5*col+3)=G_SequenceDlg->m_SQ06;

*(Para+6*col)=G_SequenceDlg->m_SQ07_Time;			*(Para+6*col+1)=G_SequenceDlg->m_SQ07_PanSpeed;		
*(Para+6*col+2)=G_SequenceDlg->m_SQ07_TiltSpeed;	*(Para+6*col+3)=G_SequenceDlg->m_SQ07;				

*(Para+7*col)=G_SequenceDlg->m_SQ08_Time;			*(Para+7*col+1)=G_SequenceDlg->m_SQ08_PanSpeed;		
*(Para+7*col+2)=G_SequenceDlg->m_SQ08_TiltSpeed;	*(Para+7*col+3)=G_SequenceDlg->m_SQ08;				

*(Para+8*col)=G_SequenceDlg->m_SQ09_Time;			*(Para+8*col+1)=G_SequenceDlg->m_SQ09_PanSpeed;		
*(Para+8*col+2)=G_SequenceDlg->m_SQ09_TiltSpeed;	*(Para+8*col+3)=G_SequenceDlg->m_SQ09;				

*(Para+9*col)=G_SequenceDlg->m_SQ10_Time;			*(Para+9*col+1)=G_SequenceDlg->m_SQ10_PanSpeed;		
*(Para+9*col+2)=G_SequenceDlg->m_SQ10_TiltSpeed;	*(Para+9*col+3)=G_SequenceDlg->m_SQ10;				

*(Para+10*col)=G_SequenceDlg->m_SQ11_Time;			*(Para+10*col+1)=G_SequenceDlg->m_SQ11_PanSpeed;	
*(Para+10*col+2)=G_SequenceDlg->m_SQ11_TiltSpeed;	*(Para+10*col+3)=G_SequenceDlg->m_SQ11;				

*(Para+11*col)=G_SequenceDlg->m_SQ12_Time;			*(Para+11*col+1)=G_SequenceDlg->m_SQ12_PanSpeed;	
*(Para+11*col+2)=G_SequenceDlg->m_SQ12_TiltSpeed;	*(Para+11*col+3)=G_SequenceDlg->m_SQ12;				

*(Para+12*col)=G_SequenceDlg->m_SQ13_Time;			*(Para+12*col+1)=G_SequenceDlg->m_SQ13_PanSpeed;	
*(Para+12*col+2)=G_SequenceDlg->m_SQ13_TiltSpeed;	*(Para+12*col+3)=G_SequenceDlg->m_SQ13;				

*(Para+13*col)=G_SequenceDlg->m_SQ14_Time;			*(Para+13*col+1)=G_SequenceDlg->m_SQ14_PanSpeed;	
*(Para+13*col+2)=G_SequenceDlg->m_SQ14_TiltSpeed;	*(Para+13*col+3)=G_SequenceDlg->m_SQ14;				

*(Para+14*col)=G_SequenceDlg->m_SQ15_Time;			*(Para+14*col+1)=G_SequenceDlg->m_SQ15_PanSpeed;	
*(Para+14*col+2)=G_SequenceDlg->m_SQ15_TiltSpeed;	*(Para+14*col+3)=G_SequenceDlg->m_SQ15;				

*(Para+15*col)=G_SequenceDlg->m_SQ16_Time;			*(Para+15*col+1)=G_SequenceDlg->m_SQ16_PanSpeed;	
*(Para+15*col+2)=G_SequenceDlg->m_SQ16_TiltSpeed;	*(Para+15*col+3)=G_SequenceDlg->m_SQ16;				

/*-- Fill empty data
for (int i=REAL_NUM_SEQUENCE;i<=(AVL_NUM_SEQUENCE-1);i++)
	for (int j=0;j<=(col-1);j++)
		Para[i*col+j]=0xff;
---*/

for (int i=0;i<=(REAL_NUM_SEQUENCE-1);i++ )
	{
	for( int j=0;j<=(EE_SIZE_SEQUENCE-1);j++ )
		{//----------------------
		Temp=Para[i*col+j];
		if (j==0)	//-- Dwell Time
			Temp=Temp*2;
		if (j==1)   //-- Pan Speed
			{ }
		if (j==2)	//-- Tilt Speed
			{ }
		if (j==3)	//-- Preset No.
			{
			if(Temp==0)	Temp=0xff;
			else		Temp=Temp-1;
			}

		Para[i*col+j]=Temp;
		}//---------------------------
	}


}
